//
//  OPPlayer.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OPEntity.h"

@class OPStatusHeart, OPItem;

@interface OPPlayer : OPEntity
{
	int					heartCount;
	double				lastAttackTime;
	OPDirection			lastDirectionMoved;
	BOOL				attacking;
	NSMutableArray		*health;
	int					numberOfUpdatesAttack;

	OPItem				*weapon;
	OPItem				*weaponIcon;
	
}
- (void)drawStatus;
- (void)drawWeapon;

- (void)showAttackAnimation;
- (void)showMovingAnimation;
- (void)restoreLastMoveDirection;
- (void)setWeaponLocation;


- (BOOL)isAttacking;
- (void)attack;

- (OPItem *)weapon;
@end
